
#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples, 
#we welcome you to contact us at SampleCode@melissadata.com also please visit our 
#developers bulletin board at forum.melissadata.com.
#********************************************************************************

use mdNamePerlWrapper;


my $LICENSE = "license here";
my $FILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data";

#.................................................................................


$nameObj = new mdNamePerlWrapper::mdName();

# ********************** LICENSE STRINGS ***********************
# *     To unlock the functionality of Name Object,    *
# * please call a sales representative at 1-800-MELISSA ext. 3 * 
# *         (1-800-635-4772 x3) for a license string.          *
# *      Without a valid license string, Name Object will     *
# *                	not function         		      *
# **************************************************************
        
# Set the License String 
if($nameObj->SetLicenseString($LICENSE) == "0")
{
	printf "License String is not Valid. Please contact a sales representative at 1-800-800-6245 x3";
	die "Invalid License";
}


# Set paths for data files in Initialize method
$nameObj->SetPathToNameFiles($FILELOC);

#Set options
$nameObj->SetFirstNameSpellingCorrection(1);
$nameObj->SetPrimaryNameHint(2);
$nameObj->SetSalutationPrefix("Dear");
$nameObj->SetSalutationSuffix(":");
$nameObj->SetSalutationSlug("Valued Customer");

my $InitResult = $nameObj->InitializeDataFiles();
if ($InitResult != 0)
{
	printf $nameObj->GetInitializeErrorString(), "\n";
	die "Cannot Initialize Name Object";	
}

#.................................................................................

# Get the Build number and DB Date
print "\n";
print "========================================================================\n";
print "           Melissa Data NameObject PERL Sample\n";
print "========================================================================\n";
print "\n";
print "            Build Number: ", $nameObj->GetBuildNumber(), "\n";
print "       Initialize Status: ", $nameObj->GetInitializeErrorString(), "\n";
print "           Database Date: ", $nameObj->GetDatabaseDate(), "\n";
print "Database Expiration Date: ", $nameObj->GetDatabaseExpirationDate(), "\n";
print " License Expiration Date: ", $nameObj->GetLicenseExpirationDate(), "\n";
print "========================================================================\n";
print "\n";

#.................................................................................

print "Enter Full Name: ";
$Name = <>;

chomp($Name);

$nameObj->ClearProperties();
$nameObj->SetFullName($Name);

my $result = $nameObj->Parse();


print "\n";
print "      Prefix :     ", $nameObj->GetPrefix(), "\n";
print "  First Name :     ", $nameObj->GetFirstName(), "\n";
print " Middle Name :     ", $nameObj->GetMiddleName(), "\n";
print "   Last Name :     ", $nameObj->GetLastName(), "\n";
print "      Suffix :     ", $nameObj->GetSuffix(), "\n";
print "      Gender :     ", $nameObj->GetGender(), "\n";
print "     Prefix2 :     ", $nameObj->GetPrefix2(), "\n";
print " First Name2 :     ", $nameObj->GetFirstName2(), "\n";
print "Middle Name2 :     ", $nameObj->GetMiddleName2(), "\n";
print "  Last Name2 :     ", $nameObj->GetLastName2(), "\n";
print "     Suffix2 :     ", $nameObj->GetSuffix2(), "\n";
print "     Gender2 :     ", $nameObj->GetGender2(), "\n";
print "  Salutation :     ", $nameObj->GetSalutation(), "\n";
print "\n";       
print "Results Codes...\n";

$ResultsString = $nameObj->GetResults();

if ($ResultsString =~ m/NS01/i)
{
   print "NS01: There were no Errors\n";
}
if ($ResultsString =~ m/NS03/i)
{
   print "NS03: The spelling of the FirstName field was corrected\n";
} 
if ($ResultsString =~ m/NS04/i)
{
   print "NS04: The spelling of the FirstName2 field was corrected\n";
}  
if ($ResultsString =~ m/NS02/i)
{
   print "NS02: There was a parse Error detected...\n";
} 
if ($ResultsString =~ m/NE01/i)
{
   print "NE01: Two names were detected but the FullName string was not in a recognized format\n";
} 
if ($ResultsString =~ m/NE02/i)
{
   print "NE02: Multiple first names  could not accurately genderize\n";
}  
if ($ResultsString =~ m/NE03/i)
{
   print "NE03: A vulgarity was detected in the name\n";
}  
if ($ResultsString =~ m/NE04/i)
{
   print "NE04: The name contained words found on the list of nuisance names [such as Mickey Mouse]\n";
}  
if ($ResultsString =~ m/NE05/i)
{
   print "NE05: The name contained words normally found in a company name\n";
}  
if ($ResultsString =~ m/NE06/i)
{
   print "NE06: The named contained a non-alphabetic character\n";
} 
print "\n"; 